/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.MatteGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MatteDecorationPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class MistAquaSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Mist Aqua";

    public MistAquaSkin() {
        SubstanceAquaTheme activeTheme = new SubstanceAquaTheme();
        SubstanceTheme defaultTheme = new SubstanceTheme(new MetallicColorScheme(), "Shade Metallic", SubstanceTheme.ThemeKind.COLD).shade(0.05);
        SubstanceTheme disabledTheme = new SubstanceTheme(new LightGrayColorScheme(), "Tone Light Gray", SubstanceTheme.ThemeKind.COLD).tone(0.2);
        SubstanceTheme activeTitleTheme = new SubstanceTheme(new ActiveTitleScheme(), "Silver Active Title", SubstanceTheme.ThemeKind.COLD);
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.registerDecorationAreaTheme(activeTitleTheme, false, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        this.theme = theme;
        this.buttonShaper = new StandardButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new MatteGradientPainter();
        this.borderPainter = new ClassicBorderPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class ActiveTitleScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = new Color(197, 197, 197);
        private static final Color mainExtraLightColor = new Color(185, 185, 185);
        private static final Color mainLightColor = new Color(170, 170, 170);
        private static final Color mainMidColor = new Color(152, 152, 152);
        private static final Color mainDarkColor = new Color(152, 152, 152);
        private static final Color mainUltraDarkColor = new Color(152, 152, 152);
        private static final Color foregroundColor = Color.decode("#000000");

        protected ActiveTitleScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

