/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.SteelBlueColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.BrushedMetalDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class BusinessBlackSteelSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Business Black Steel";

    public BusinessBlackSteelSkin() {
        SubstanceTheme activeTheme = new SubstanceTheme(new SteelBlueColorScheme(), "Tint Steel Blue", SubstanceTheme.ThemeKind.COLD).tint(0.15);
        SubstanceTheme defaultTheme = new SubstanceTheme(new MetallicColorScheme(), "Tint Metallic", SubstanceTheme.ThemeKind.COLD).tint(0.05);
        SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme();
        SubstanceEbonyTheme activeTitleTheme = new SubstanceEbonyTheme();
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.registerComponentHighlightStateTheme(activeTheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        theme.registerComponentHighlightStateTheme(activeTheme, 0.8f, ComponentState.SELECTED);
        theme.registerComponentHighlightStateTheme(activeTheme, 0.95f, ComponentState.ROLLOVER_SELECTED);
        theme.registerComponentHighlightStateTheme(activeTheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceComplexTheme decorationTheme = new SubstanceComplexTheme("Business Black Steel Decoration", SubstanceTheme.ThemeKind.DARK, activeTitleTheme.shade(0.3), activeTitleTheme, disabledTheme);
        theme.registerDecorationAreaTheme(decorationTheme, true, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
        theme.registerDecorationAreaTheme(activeTitleTheme, false, DecorationAreaType.HEADER);
        SubstanceComplexTheme generalDecorationTheme = new SubstanceComplexTheme("Business Black Steel General Decoration", SubstanceTheme.ThemeKind.DARK, activeTheme.shade(0.1).saturate(-0.5), activeTheme.tint(0.3).saturate(-0.7), disabledTheme);
        generalDecorationTheme.registerComponentStateTheme(disabledTheme, 0.5f, false, ComponentState.DISABLED_UNSELECTED);
        theme.registerDecorationAreaTheme(generalDecorationTheme, true, DecorationAreaType.GENERAL);
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setDefaultTitlePaneTheme(activeTitleTheme);
        theme.setPaintingToolbarDropShadows();
        this.theme = theme;
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new ClassicGradientPainter();
        this.borderPainter = new ClassicBorderPainter();
        BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
        decorationPainter.setBaseDecorationPainter(new ArcDecorationPainter());
        decorationPainter.setTextureAlpha(0.02f);
        this.decorationPainter = decorationPainter;
        this.highlightPainter = new ClassicHighlightPainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
        this.borderPainter = new ClassicBorderPainter();
    }

    public String getDisplayName() {
        return NAME;
    }
}

