/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ShiftColorScheme
extends BaseColorScheme {
    private double backgroundShiftFactor;
    private double foregroundShiftFactor;
    private Color backgroundShiftColor;
    private Color foregroundShiftColor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public ShiftColorScheme(ColorScheme origScheme, Color shiftColor, double shiftFactor) {
        this(origScheme, shiftColor, shiftFactor, shiftColor, shiftFactor / 2.0, false);
    }

    public ShiftColorScheme(ColorScheme origScheme, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor, boolean shiftByBrightness) {
        this.backgroundShiftColor = backgroundShiftColor;
        this.backgroundShiftFactor = backgroundShiftFactor;
        this.foregroundShiftColor = foregroundShiftColor;
        this.foregroundShiftFactor = foregroundShiftFactor;
        this.origScheme = origScheme;
        this.foregroundColor = this.foregroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(this.foregroundShiftColor, origScheme.getForegroundColor(), this.foregroundShiftFactor) : origScheme.getForegroundColor();
        shiftByBrightness = shiftByBrightness && this.backgroundShiftColor != null;
        Color ultraDarkToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getUltraDarkColor()) : this.backgroundShiftColor;
        this.mainUltraDarkColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(ultraDarkToShiftTo, origScheme.getUltraDarkColor(), this.backgroundShiftFactor) : origScheme.getUltraDarkColor();
        Color darkToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getDarkColor()) : this.backgroundShiftColor;
        this.mainDarkColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(darkToShiftTo, origScheme.getDarkColor(), this.backgroundShiftFactor) : origScheme.getDarkColor();
        Color midToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getMidColor()) : this.backgroundShiftColor;
        this.mainMidColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(midToShiftTo, origScheme.getMidColor(), this.backgroundShiftFactor) : origScheme.getMidColor();
        Color lightToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getLightColor()) : this.backgroundShiftColor;
        this.mainLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(lightToShiftTo, origScheme.getLightColor(), this.backgroundShiftFactor) : origScheme.getLightColor();
        Color extraLightToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getExtraLightColor()) : this.backgroundShiftColor;
        this.mainExtraLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(extraLightToShiftTo, origScheme.getExtraLightColor(), this.backgroundShiftFactor) : origScheme.getExtraLightColor();
        Color ultraLightToShiftTo = shiftByBrightness ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, origScheme.getUltraLightColor()) : this.backgroundShiftColor;
        this.mainUltraLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(ultraLightToShiftTo, origScheme.getUltraLightColor(), this.backgroundShiftFactor) : origScheme.getUltraLightColor();
        this.id = this.getClass().getName() + "[" + SubstanceCoreUtilities.getSchemeId(origScheme) + "->" + backgroundShiftColor + "," + backgroundShiftFactor + ":" + shiftByBrightness + "]";
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getShiftFactor() {
        return this.backgroundShiftFactor;
    }
}

