/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class StandardButtonShaper
extends BaseButtonShaper
implements RectangularButtonShaper {
    public static Map<String, GeneralPath> contours = new SoftHashMap<String, GeneralPath>();

    public String getDisplayName() {
        return "Standard";
    }

    public GeneralPath getButtonOutline(AbstractButton button, Insets insets, int width, int height) {
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        float radius = this.getCornerRadius(button, insets);
        String key = width + ":" + height + ":";
        if (straightSides != null) {
            for (SubstanceConstants.Side side : straightSides) {
                key = key + (Object)((Object)side) + ":";
            }
        }
        key = key + radius + ":";
        GeneralPath result = contours.get(key = key + (insets == null ? "null" : insets.toString()));
        if (result != null) {
            return result;
        }
        result = StandardButtonShaper.getBaseOutline(width, height, radius, straightSides, insets);
        contours.put(key, result);
        return result;
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(StandardButtonShaper.class){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(c));
                if (c instanceof AbstractButton && SubstanceCoreUtilities.hasText(button = (AbstractButton)c)) {
                    int dh = SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button));
                    return new Insets(extraPadding, extraPadding + dh / 2, extraPadding, extraPadding + dh / 2);
                }
                return new Insets(extraPadding, extraPadding, extraPadding, extraPadding);
            }
        };
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            baseHeight = Math.max(baseHeight, SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        if (result.height % 2 == 1) {
            ++result.height;
        }
        return result;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public boolean isProportionate() {
        return true;
    }

    public float getCornerRadius(AbstractButton button, Insets insets) {
        int width = button.getWidth();
        int height = button.getHeight();
        boolean isRoundCorners = StandardButtonShaper.isRoundButton(button);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (isRoundCorners) {
            radius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        }
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

