/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.text.SubstanceHighlighter;
import org.jvnet.substance.text.SubstancePlainView;
import org.jvnet.substance.text.SubstanceWrappedPlainView;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceTextAreaUI
extends BasicTextAreaUI {
    protected Set lafWidgets;
    protected FadeStateListener substanceFadeStateListener;
    protected JTextArea textArea;
    protected PropertyChangeListener substancePropertyChangeListener;

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTextAreaUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTextAreaUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTextAreaUI(c);
    }

    public SubstanceTextAreaUI(JComponent c) {
        this.textArea = (JTextArea)c;
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textArea, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTextAreaUI.this.textArea.updateUI();
                        }
                    });
                }
            }
        };
        this.textArea.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textArea.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__installDefaults() {
        super.installDefaults();
        Border b = this.textArea.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textArea))), new BasicBorders.MarginBorder());
            this.textArea.setBorder(newB);
        }
    }

    protected Highlighter createHighlighter() {
        return new SubstanceHighlighter();
    }

    public View create(Element elem) {
        View superResult = super.create(elem);
        if (superResult instanceof PlainView) {
            return new SubstancePlainView(elem);
        }
        if (superResult instanceof WrappedPlainView) {
            return new SubstanceWrappedPlainView(elem, ((JTextArea)this.getComponent()).getWrapStyleWord());
        }
        return superResult;
    }

    protected void modelChanged() {
        super.modelChanged();
        JTextComponent component = this.getComponent();
        View currView = this.getRootView(component);
        Element defaultRootElement = component.getDocument().getDefaultRootElement();
        if (currView instanceof PlainView) {
            this.setView(new SubstancePlainView(defaultRootElement));
        }
        if (currView instanceof WrappedPlainView) {
            this.setView(new SubstanceWrappedPlainView(defaultRootElement, ((JTextArea)this.getComponent()).getWrapStyleWord()));
        }
    }

    protected void paintSafely(Graphics _g) {
        Graphics2D dummy = (Graphics2D)_g.create(0, 0, 0, 0);
        super.paintSafely(dummy);
        dummy.dispose();
        SubstanceCoreUtilities.paintTextComponent(_g, this.textArea, this.getRootView(this.textArea), this.getVisibleEditorRect());
    }
}

