/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultTableHeaderCellRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceTableHeaderUI
extends BasicTableHeaderUI {
    protected Set lafWidgets;
    protected TableHeaderListener substanceHeaderListener;
    protected TableCellRenderer defaultHeaderRenderer;
    protected Map<Integer, Object> selectedIndices;
    protected ListSelectionListener substanceFadeSelectionListener;
    private Map<Integer, ComponentState> prevStateMap = new HashMap<Integer, ComponentState>();
    private Map<Integer, ComponentState> nextStateMap = new HashMap<Integer, ComponentState>();
    protected PropertyChangeListener substancePropertyChangeListener;

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTableHeaderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTableHeaderUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent h) {
        SubstanceTableHeaderUI result = new SubstanceTableHeaderUI();
        return result;
    }

    public SubstanceTableHeaderUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__installListeners() {
        ListSelectionModel lsm;
        super.installListeners();
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            this.substanceHeaderListener = new TableHeaderListener(this);
            lsm.addListSelectionListener(this.substanceHeaderListener);
        }
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SubstanceTableHeaderUI.this.header == null) {
                    return;
                }
                SubstanceTableUI tableUI = (SubstanceTableUI)SubstanceTableHeaderUI.this.header.getTable().getUI();
                if (!tableUI.hasSelectionAnimations()) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                TableColumnModel columnModel = SubstanceTableHeaderUI.this.header.getColumnModel();
                int size = columnModel.getColumnCount();
                ListSelectionModel lsm = columnModel.getSelectionModel();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    long fadeId;
                    if (i >= size) continue;
                    if (lsm.isSelectedIndex(i)) {
                        if (SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceTableHeaderUI.this.header, i, false, (FadeTrackerCallback)new ColumnHeaderRepaintCallback(SubstanceTableHeaderUI.this.header, i));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceTableHeaderUI.this.selectedIndices.put(i, columnModel.getColumn(i));
                        continue;
                    }
                    if (!SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                    if (SubstanceTableHeaderUI.this.selectedIndices.get(i) == columnModel.getColumn(i) && !fadeCanceled) {
                        fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceTableHeaderUI.this.header, i, false, (FadeTrackerCallback)new ColumnHeaderRepaintCallback(SubstanceTableHeaderUI.this.header, i));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 25) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    }
                    SubstanceTableHeaderUI.this.selectedIndices.remove(i);
                }
            }
        };
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.addListSelectionListener(this.substanceFadeSelectionListener);
        }
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("table".equals(evt.getPropertyName())) {
                    TableColumnModel oldModel = evt.getOldValue() instanceof JTable ? ((JTable)evt.getOldValue()).getColumnModel() : null;
                    TableColumnModel newModel = evt.getNewValue() instanceof JTable ? ((JTable)evt.getNewValue()).getColumnModel() : null;
                    SubstanceTableHeaderUI.this.processColumnModelChangeEvent(oldModel, newModel);
                }
            }
        };
        this.header.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__installDefaults() {
        super.installDefaults();
        this.defaultHeaderRenderer = this.header.getDefaultRenderer();
        if (this.defaultHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new SubstanceDefaultTableHeaderCellRenderer());
        }
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            if (!this.header.getColumnModel().getSelectionModel().isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.header.getColumnModel().getColumn(i));
            this.prevStateMap.put(i, ComponentState.SELECTED);
        }
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallListeners() {
        ListSelectionModel lsm;
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.removeListSelectionListener(this.substanceHeaderListener);
            this.substanceHeaderListener = null;
        }
        this.header.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedIndices.clear();
        if (this.header.getDefaultRenderer() instanceof SubstanceDefaultTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.defaultHeaderRenderer);
            if (this.defaultHeaderRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.defaultHeaderRenderer));
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        int columnWidth;
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int[] selectedColumns = cm.getSelectedColumns();
        HashSet<Integer> selected = new HashSet<Integer>();
        for (int sel : selectedColumns) {
            selected.add(sel);
        }
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        }
        this.paintGrid(g, c);
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex, selected.contains(draggedColumnIndex));
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    public void paintGrid(Graphics g, JComponent c) {
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        Rectangle cellRect0 = this.header.getHeaderRect(cMin);
        int top = cellRect0.y;
        int bottom = cellRect0.y + cellRect0.height;
        Color gridColor = SubstanceTableHeaderUI.getGridColor(this.header);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.header));
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(gridColor);
        g2d.setComposite(TransitionLayout.getAlphaComposite(this.header, 0.7f, g));
        g2d.drawLine((int)left.getX(), (int)((float)bottom - strokeWidth / 2.0f), (int)right.getX(), (int)((float)bottom - strokeWidth / 2.0f));
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (int column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    g2d.drawLine(cellRect.x - 1, cellRect.y, cellRect.x - 1, bottom);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (int column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    g2d.drawLine(cellRect.x - 1, cellRect.y, cellRect.x - 1, bottom);
                }
                cellRect.x += columnWidth;
            }
        }
        g2d.dispose();
    }

    protected static Color getGridColor(JTableHeader header) {
        ComponentState currState = header.isEnabled() && header.getTable().isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        SubstanceTheme currTheme = SubstanceThemeUtilities.getHighlightTheme(header, currState);
        Color gridColor = currTheme.getBorderTheme().getColorScheme().getDarkColor();
        return gridColor;
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.header, g));
        final Component component = this.getHeaderRenderer(columnIndex);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        ComponentState prevState = this.getPrevColumnState(columnIndex);
        ComponentState currState = this.getColumnState(columnIndex);
        ComponentState backgroundState = this.header.isEnabled() && this.header.getTable().isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        final SubstanceTheme theme = SubstanceThemeUtilities.getTheme(component, backgroundState);
        if (textPainter.needsBackgroundImage()) {
            final Rectangle offsetCellRect = new Rectangle(0, 0, cellRect.width, cellRect.height);
            textPainter.init(this.header, offsetCellRect, true);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    SubstanceHighlightUtils.paintHighlight(g2d, component, offsetCellRect, 0.0f, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f);
                    g2d.dispose();
                }
            });
        } else {
            SubstanceHighlightUtils.paintHighlight(g2d, component, cellRect, 0.0f, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f);
        }
        float startAlpha = SubstanceThemeUtilities.getHighlightAlpha(this.header, prevState);
        float endAlpha = SubstanceThemeUtilities.getHighlightAlpha(this.header, currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.header, Integer.valueOf(columnIndex), FadeKind.SELECTION, FadeKind.ROLLOVER);
        float totalAlpha = endAlpha;
        float fadeCoef = 0.0f;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
        }
        final SubstanceTheme prevTheme = SubstanceThemeUtilities.getHighlightTheme(this.header, prevState);
        final SubstanceTheme currTheme = SubstanceThemeUtilities.getHighlightTheme(this.header, currState);
        if (textPainter.needsBackgroundImage()) {
            final float finalTotalAlpha = totalAlpha;
            final float finalFadeCoef = fadeCoef;
            final Rectangle offsetCellRect = new Rectangle(0, 0, cellRect.width, cellRect.height);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    if (finalTotalAlpha > 0.0f) {
                        g2d.setComposite(TransitionLayout.getAlphaComposite(SubstanceTableHeaderUI.this.header, finalTotalAlpha, g));
                        SubstanceHighlightUtils.paintHighlight(g2d, component, offsetCellRect, 0.0f, null, currTheme.getColorScheme(), prevTheme.getColorScheme(), finalFadeCoef);
                        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceTableHeaderUI.this.header, g));
                    }
                    g2d.dispose();
                }
            });
        } else if (totalAlpha > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.header, totalAlpha, g));
            SubstanceHighlightUtils.paintHighlight(g2d, component, cellRect, 0.0f, null, currTheme.getColorScheme(), prevTheme.getColorScheme(), fadeCoef);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.header, g));
        }
        this.header.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", Boolean.TRUE);
        this.rendererPane.paintComponent(g2d, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        this.header.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", null);
        g2d.dispose();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__update(Graphics g, JComponent c) {
        ComponentState backgroundState = this.header.isEnabled() && this.header.getTable().isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(c, backgroundState);
        SubstanceHighlightUtils.paintHighlight(g, c, c.getBounds(), 0.0f, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f);
        this.paint(g, c);
    }

    public void __org__jvnet__substance__SubstanceTableHeaderUI__uninstallUI(JComponent c) {
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            TableColumn aColumn = this.header.getColumnModel().getColumn(i);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.header.getDefaultRenderer();
            }
            Component rendComp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, i);
            SwingUtilities.updateComponentTreeUI(rendComp);
        }
        super.uninstallUI(c);
    }

    public ComponentState getPrevColumnState(int columnIndex) {
        if (this.header.isEnabled() && this.header.getTable().isEnabled() && SubstanceDefaultTableHeaderCellRenderer.isColumnSorted(this.header.getTable(), columnIndex)) {
            return ComponentState.SELECTED;
        }
        if (this.prevStateMap.containsKey(columnIndex)) {
            return this.prevStateMap.get(columnIndex);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getColumnState(int columnIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        boolean toEnable = this.header.isEnabled();
        JTable table = this.header.getTable();
        if (table != null) {
            toEnable = toEnable && table.isEnabled();
            TableUI ui = table.getUI();
            if (ui instanceof SubstanceTableUI) {
                SubstanceTableUI tableUI = (SubstanceTableUI)table.getUI();
                int rolledOverIndex = tableUI.getRolloverColumnIndex();
                synthModel.setRollover(rolledOverIndex >= 0 && rolledOverIndex == columnIndex);
            }
        }
        if (toEnable && SubstanceDefaultTableHeaderCellRenderer.isColumnSorted(this.header.getTable(), columnIndex)) {
            return ComponentState.SELECTED;
        }
        synthModel.setEnabled(toEnable);
        TableColumnModel columnModel = this.header.getColumnModel();
        synthModel.setSelected(columnModel.getColumnSelectionAllowed() && columnModel.getSelectionModel().isSelectedIndex(columnIndex));
        return ComponentState.getState(synthModel, null);
    }

    public FadeTrackerCallback getCallback(int columnIndex) {
        return new ColumnHeaderRepaintCallback(this.header, columnIndex);
    }

    public JComponent getScrollPaneCornerFiller() {
        return new ScrollPaneCornerFiller(this.header);
    }

    public void processColumnModelChangeEvent(TableColumnModel oldModel, TableColumnModel newModel) {
        if (oldModel != null) {
            oldModel.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        }
        if (newModel != null) {
            newModel.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        }
        this.selectedIndices.clear();
        this.prevStateMap.clear();
        this.nextStateMap.clear();
    }

    protected class ColumnHeaderRepaintCallback
    extends FadeTrackerAdapter {
        protected JTableHeader header;
        protected int columnIndex;

        public ColumnHeaderRepaintCallback(JTableHeader header, int columnIndex) {
            this.header = header;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                ComponentState currState = SubstanceTableHeaderUI.this.getColumnState(this.columnIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceTableHeaderUI.this.prevStateMap.remove(this.columnIndex);
                    SubstanceTableHeaderUI.this.nextStateMap.remove(this.columnIndex);
                } else {
                    SubstanceTableHeaderUI.this.prevStateMap.put(this.columnIndex, currState);
                    SubstanceTableHeaderUI.this.nextStateMap.put(this.columnIndex, currState);
                }
            }
            this.repaintColumnHeader();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                ComponentState nextState = (ComponentState)((Object)SubstanceTableHeaderUI.this.nextStateMap.get(this.columnIndex));
                if (nextState == null) {
                    SubstanceTableHeaderUI.this.prevStateMap.remove(this.columnIndex);
                } else {
                    SubstanceTableHeaderUI.this.prevStateMap.put(this.columnIndex, nextState);
                }
            }
            this.repaintColumnHeader();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTableHeaderUI.this.header == this.header && this.columnIndex < this.header.getColumnModel().getColumnCount()) {
                SubstanceTableHeaderUI.this.nextStateMap.put(this.columnIndex, SubstanceTableHeaderUI.this.getColumnState(this.columnIndex));
            }
            this.repaintColumnHeader();
        }

        private void repaintColumnHeader() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ColumnHeaderRepaintCallback.this.header == null) {
                        return;
                    }
                    try {
                        int cellCount = ColumnHeaderRepaintCallback.this.header.getColumnModel().getColumnCount();
                        if (cellCount > 0 && ColumnHeaderRepaintCallback.this.columnIndex < cellCount) {
                            Rectangle rect = ColumnHeaderRepaintCallback.this.header.getHeaderRect(ColumnHeaderRepaintCallback.this.columnIndex);
                            Rectangle damaged = new Rectangle(rect.x - 5, rect.y, rect.width + 10, rect.height);
                            ColumnHeaderRepaintCallback.this.header.repaint(damaged);
                        }
                    }
                    catch (RuntimeException re) {
                        return;
                    }
                }
            });
        }
    }

    protected static class ScrollPaneCornerFiller
    extends JComponent
    implements UIResource {
        protected JTableHeader header;

        public ScrollPaneCornerFiller(JTableHeader header) {
            this.header = header;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            boolean ltr = this.header.getComponentOrientation().isLeftToRight();
            ComponentState backgroundState = this.header.isEnabled() && this.header.getTable().isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
            SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.header, backgroundState);
            SubstanceHighlightUtils.paintHighlight(g2d, this.header, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0.0f, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f);
            g2d.setColor(SubstanceTableHeaderUI.getGridColor(this.header));
            float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.header));
            g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.header, 0.7f, g));
            int x = ltr ? (int)strokeWidth / 2 : this.getWidth() - 1 - (int)strokeWidth / 2;
            g2d.drawLine(x, 0, x, this.getHeight());
            g2d.dispose();
        }
    }

    private static class TableHeaderListener
    implements ListSelectionListener {
        private SubstanceTableHeaderUI ui;

        public TableHeaderListener(SubstanceTableHeaderUI ui) {
            this.ui = ui;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this.ui.header == null) {
                return;
            }
            if (this.ui.header.isValid()) {
                this.ui.header.repaint();
            }
        }
    }
}

