/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

public class SubstanceSliderUI
extends BasicSliderUI
implements Trackable {
    protected Set lafWidgets;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;
    protected Icon horizontalIcon;
    protected Icon roundIcon;
    protected Icon verticalIcon;

    public void installDefaults(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installDefaults(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceSliderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceSliderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSliderUI((JSlider)c);
    }

    public SubstanceSliderUI(JSlider slider) {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(slider.isEnabled());
    }

    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 0) {
            this.trackRect.y = 3 + (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) + this.insetCache.top;
        }
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackTop = 3 + this.insetCache.top + 2 * this.focusInsets.top;
            trackBottom = trackTop + this.getTrackWidth() - 1;
            trackRight = this.trackRect.width;
            return new Rectangle(this.trackRect.x + trackLeft, trackTop, trackRight - trackLeft, trackBottom - trackTop);
        }
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            trackLeft = 6 + this.insetCache.left + this.focusInsets.left;
            trackRight = trackLeft + this.getTrackWidth() - 1;
        } else {
            trackRight = this.slider.getWidth() - 8 - this.insetCache.right;
            trackLeft = trackRight - this.getTrackWidth() + 1;
        }
        trackBottom = this.trackRect.height - 1;
        return new Rectangle(trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        graphics.translate(paintRect.x, paintRect.y);
        int width = paintRect.width;
        int height = paintRect.height;
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.slider);
        SubstanceTheme trackTheme = SubstanceThemeUtilities.getTheme(this.slider);
        trackTheme = this.slider.isEnabled() ? trackTheme.getDefaultTheme() : trackTheme.getDisabledTheme();
        this.paintSliderTrack(graphics, drawInverted, trackTheme, width, height, this.slider.getOrientation() == 1);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.slider, currState);
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.slider, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
        if (fadeState != null) {
            SubstanceTheme prevTheme = SubstanceThemeUtilities.getTheme(this.slider, prevState);
            float cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            if (prevState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, 1.0f - cyclePos / 10.0f, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, prevTheme, width, height);
            }
            if (currState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, cyclePos / 10.0f, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, theme, width, height);
            }
        } else {
            boolean hasFill;
            boolean bl = hasFill = currState.isKindActive(FadeKind.ROLLOVER) || currState.isKindActive(FadeKind.PRESS) || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.slider, true);
            if (hasFill) {
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, theme, width, height);
            }
        }
        graphics.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics, boolean drawInverted, SubstanceTheme theme, int width, int height, boolean toRotate) {
        ClassicGradientPainter gradientPainter = new ClassicGradientPainter();
        ColorScheme fillColorScheme = theme.getColorScheme();
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        if (toRotate) {
            BufferedImage image = SubstanceCoreUtilities.getBlankImage(height + 1, width + 1);
            this.paintSliderTrack((Graphics2D)image.getGraphics(), drawInverted, theme, height, width, false);
            BufferedImage track = SubstanceImageCreator.getRotated(image, 3);
            graphics.drawImage((Image)track, 0, 0, null);
            return;
        }
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0f;
        GeneralPath contour = BaseButtonShaper.getBaseOutline(width + 1, height + 1, radius, null, borderDelta);
        BufferedImage fillTrackImage = gradientPainter.getContourBackground(width, height, contour, false, fillColorScheme, fillColorScheme, 0.0f, false, false);
        graphics.drawImage((Image)fillTrackImage, 0, 0, null);
        ColorScheme borderScheme = theme.getBorderTheme().getColorScheme();
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider));
        GeneralPath contourInner = BaseButtonShaper.getBaseOutline(width + 1, height + 1, radius, null, borderThickness + borderDelta);
        borderPainter.paintBorder(graphics, this.slider, width + 1, height + 1, contour, contourInner, borderScheme, borderScheme, 0.0f, false);
    }

    private void paintSliderTrackSelected(Graphics2D graphics, boolean drawInverted, Rectangle paintRect, SubstanceTheme theme, int width, int height) {
        Insets insets = this.slider.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        SubstanceGradientPainter gp = SubstanceCoreUtilities.getGradientPainter(this.slider);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0f;
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0);
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width;
                } else {
                    fillMinX = 0;
                    fillMaxX = middleOfThumb;
                }
                int fillWidth = fillMaxX - fillMinX;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = BaseButtonShaper.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    BufferedImage im = gp.getContourBackground(fillWidth, fillHeight, contour, false, theme.getColorScheme(), theme.getColorScheme(), 0.0f, false, false);
                    borderPainter.paintBorder(im.getGraphics(), this.slider, fillWidth, fillHeight, contour, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f, false);
                    graphics.drawImage((Image)im, fillMinX, 0, null);
                }
            } else {
                int fillMaxY;
                int fillMinY;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                if (this.drawInverted()) {
                    fillMinY = 0;
                    fillMaxY = middleOfThumb;
                } else {
                    fillMinY = middleOfThumb;
                    fillMaxY = height + 1;
                }
                int fillWidth = fillMaxY - fillMinY;
                int fillHeight = width + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = BaseButtonShaper.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    BufferedImage im = gp.getContourBackground(fillWidth, fillHeight, contour, false, theme.getColorScheme(), theme.getColorScheme(), 0.0f, false, false);
                    borderPainter.paintBorder(im.getGraphics(), this.slider, fillWidth, fillHeight, contour, null, theme.getColorScheme(), theme.getColorScheme(), 0.0f, false);
                    im = SubstanceImageCreator.getRotated(im, 1);
                    graphics.drawImage((Image)im, 0, fillMinY, null);
                }
            }
        }
    }

    protected Dimension getThumbSize() {
        Icon thumbIcon = this.getIcon();
        return new Dimension(thumbIcon.getIconWidth(), thumbIcon.getIconHeight());
    }

    protected Icon getIcon() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
                return this.horizontalIcon;
            }
            return this.roundIcon;
        }
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return this.verticalIcon;
        }
        return this.roundIcon;
    }

    public void paintThumb(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle knobBounds = this.thumbRect;
        graphics.translate(knobBounds.x, knobBounds.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, -1, 0);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, 0, -1);
            }
        } else if (icon != null) {
            icon.paintIcon(this.slider, graphics, 0, 1);
        }
        graphics.dispose();
    }

    public synchronized void paint(Graphics g, final JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        float alpha = SubstanceThemeUtilities.getTheme(this.slider).getThemeAlpha(this.slider, currState);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(c, null, true);
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(c, c.getBackground(), true, 0, 0);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    bgDelegate.updateIfOpaque(g, c);
                }
            });
        } else {
            bgDelegate.updateIfOpaque(graphics, c);
        }
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        final Rectangle clip = graphics.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, alpha, g));
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                if (SubstanceSliderUI.this.slider.getPaintTrack() && clip.intersects(SubstanceSliderUI.this.trackRect)) {
                    SubstanceSliderUI.this.paintTrack(g);
                }
                if (SubstanceSliderUI.this.slider.getPaintTicks() && clip.intersects(SubstanceSliderUI.this.tickRect)) {
                    SubstanceSliderUI.this.paintTicks(g);
                }
                if (SubstanceSliderUI.this.slider.hasFocus() && clip.intersects(SubstanceSliderUI.this.focusRect)) {
                    SubstanceSliderUI.this.paintFocus(g);
                }
                if (clip.intersects(SubstanceSliderUI.this.thumbRect)) {
                    SubstanceSliderUI.this.paintThumb(g);
                }
            }
        };
        if (textPainter.needsBackgroundImage()) {
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(graphics);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        textPainter.renderSurface(graphics);
        if (!this.slider.hasFocus() && FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS)) {
            this.paintFocus(graphics);
        }
        graphics.dispose();
    }

    public ButtonModel getButtonModel() {
        return this.thumbModel;
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installDefaults(JSlider slider) {
        super.installDefaults(slider);
        Font f = slider.getFont();
        if (f == null || f instanceof UIResource) {
            slider.setFont(new FontUIResource(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont()));
        }
        int size = SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getComponentFontSize(slider));
        this.horizontalIcon = SubstanceIconFactory.getSliderHorizontalIcon(size, false);
        this.roundIcon = SubstanceIconFactory.getSliderRoundIcon(size);
        this.verticalIcon = SubstanceIconFactory.getSliderVerticalIcon(size, false);
        int focusIns = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider)));
        this.focusInsets = new Insets(focusIns, focusIns, focusIns, focusIns);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installListeners(final JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceSliderUI.this.thumbModel.setEnabled(slider.isEnabled());
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            slider.updateUI();
                        }
                    });
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeStateListener = new FadeStateListener(this.slider, this.thumbModel, SubstanceCoreUtilities.getFadeCallback(this.slider, this.thumbModel, false, false, this.slider));
        this.substanceFadeStateListener.registerListeners(false);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    public void paintFocus(Graphics g) {
        SubstanceCoreUtilities.paintFocus(g, this.slider, this.slider, null, null, 1.0f, (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) / 2);
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected int getTrackWidth() {
        return SubstanceSizeUtils.getSliderTrackSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    protected int getTickLength() {
        return SubstanceSizeUtils.getSliderTickSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0 && this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum() + this.slider.getMinorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    int delta = value - this.slider.getMinimum();
                    if (delta % this.slider.getMajorTickSpacing() == 0) continue;
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum() + this.slider.getMinorTickSpacing();
            int yPos = 0;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!ltr) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum() + this.slider.getMajorTickSpacing();
                if (!ltr) {
                    g.translate(2, 0);
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!ltr) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = SubstanceThemeUtilities.getTheme(this.slider, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED).getColorScheme();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x - 1, 0);
        SubstanceCoreUtilities.paintSeparator(this.slider, graphics, colorScheme, isDark, 0, tickBounds.height, 1, true, 0, 4);
        graphics.dispose();
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = SubstanceThemeUtilities.getTheme(this.slider, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED).getColorScheme();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(0, y);
        SubstanceCoreUtilities.paintSeparator(this.slider, graphics, colorScheme, isDark, tickBounds.width - 1, 0, 0, true, this.slider.getComponentOrientation().isLeftToRight() ? 0 : 4, this.slider.getComponentOrientation().isLeftToRight() ? 4 : 0);
        graphics.dispose();
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = SubstanceThemeUtilities.getTheme(this.slider, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED).getColorScheme();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x - 1, 0);
        SubstanceCoreUtilities.paintSeparator(this.slider, graphics, colorScheme, isDark, 0, tickBounds.height / 2, 1, true, 0, 4);
        graphics.dispose();
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = SubstanceThemeUtilities.getTheme(this.slider, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED).getColorScheme();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(0, y);
        SubstanceCoreUtilities.paintSeparator(this.slider, graphics, colorScheme, isDark, tickBounds.width / 2, 0, 0, true, this.slider.getComponentOrientation().isLeftToRight() ? 0 : 4, this.slider.getComponentOrientation().isLeftToRight() ? 4 : 0);
        graphics.dispose();
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y -= 3;
            } else {
                this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= 2) : (this.tickRect.x += 2);
            }
        }
    }

    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 1 && !this.slider.getPaintTicks() && this.slider.getComponentOrientation().isLeftToRight()) {
            this.labelRect.x += 3;
        }
        if (this.slider.getOrientation() == 1) {
            this.labelRect.width = this.getHeightOfTallestLabel();
        }
    }

    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        Rectangle trackRect = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            double centerY = (double)trackRect.y + (double)trackRect.height / 2.0;
            this.thumbRect.y = (int)(centerY - (double)this.thumbRect.height / 2.0) + 1;
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            double centerX = (double)trackRect.x + (double)trackRect.width / 2.0;
            this.thumbRect.x = (int)(centerX - (double)this.thumbRect.width / 2.0) + 1;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width;
            if (this.slider.getPaintTicks()) {
                d.width += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.width += this.getWidthOfWidestLabel();
            }
            d.width += 3;
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height;
            if (this.slider.getPaintTicks()) {
                d.height += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.height += this.getHeightOfTallestLabel();
            }
            d.height += 3;
        }
        return d;
    }

    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    public Dimension getPreferredHorizontalSize() {
        return new Dimension(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false), 21);
    }

    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false));
    }

    public void paintLabels(Graphics g) {
        Rectangle labelBounds = this.labelRect;
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int minValue = this.slider.getMinimum();
            int maxValue = this.slider.getMaximum();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int value = key;
                if (value < minValue || value > maxValue) continue;
                Component label = (Component)dictionary.get(key);
                Dimension prefSize = label.getPreferredSize();
                JLabel jlabel = (JLabel)label;
                final View v = (View)jlabel.getClientProperty("html");
                String text = jlabel.getText();
                ComponentState state = this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
                Color labelColor = SubstanceCoreUtilities.getForegroundColor(jlabel, state, state);
                if (this.slider.getOrientation() == 0) {
                    final Rectangle textRect = new Rectangle(this.xPositionForValue(value) - prefSize.width / 2, labelBounds.y, prefSize.width, prefSize.height);
                    if (v != null) {
                        if (textPainter.needsBackgroundImage()) {
                            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                                public void paintBackground(Graphics g) {
                                    v.paint(g, textRect);
                                }
                            });
                            continue;
                        }
                        v.paint(g, textRect);
                        continue;
                    }
                    textPainter.attachText(this.slider, textRect, text, -1, g.getFont(), labelColor, g.getClipBounds());
                    continue;
                }
                int offset = 0;
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    offset = labelBounds.width - label.getPreferredSize().height;
                }
                Rectangle labelRect = new Rectangle(labelBounds.x + offset, this.yPositionForValue(value) - prefSize.width / 2, prefSize.height, prefSize.width);
                textPainter.attachVerticalText(this.slider, labelRect, text, -1, g.getFont(), labelColor, null, this.slider.getComponentOrientation().isLeftToRight());
            }
        }
    }
}

