/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.MenuArrowIcon;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu {
    protected boolean containerGhostingMarker;
    protected Set lafWidgets;
    protected MouseListener substanceMouseListener;
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FocusListener substanceFocusListener;

    protected void update(Graphics graphics, JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceMenuUI__container__update(graphics, jComponent);
        GhostPaintingUtils.paintGhostImages(jComponent, graphics);
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceMenuUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__uninstallComponents(JMenuItem jMenuItem) {
        super.uninstallComponents(jMenuItem);
    }

    public void uninstallComponents(JMenuItem jMenuItem) {
        this.__org__jvnet__substance__SubstanceMenuUI__uninstallComponents(jMenuItem);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceMenuUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void __org__jvnet__substance__SubstanceMenuUI__container__update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceMenuUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceMenuUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceMenuUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceMenuUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceMenuUI__installComponents(JMenuItem jMenuItem) {
        super.installComponents(jMenuItem);
    }

    public void installComponents(JMenuItem jMenuItem) {
        this.__org__jvnet__substance__SubstanceMenuUI__installComponents(jMenuItem);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceMenuUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMenuUI();
    }

    protected void __org__jvnet__substance__SubstanceMenuUI__installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.arrowIcon = new MenuArrowIcon(this.menuItem);
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
    }

    protected void __org__jvnet__substance__SubstanceMenuUI__installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            public void mouseEntered(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }
        };
        this.menuItem.addMouseListener(this.substanceMouseListener);
        this.substanceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            public void focusLost(FocusEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }
        };
        this.menuItem.addFocusListener(this.substanceFocusListener);
        final HashSet<FadeKind> toIgnore = new HashSet<FadeKind>();
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(this.menuItem, this.menuItem.getModel(), false, false, this.menuItem), toIgnore);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceMenuUI.this.substanceFadeStateListener != null) {
                        SubstanceMenuUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceMenuUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceMenuUI.this.menuItem, SubstanceMenuUI.this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(SubstanceMenuUI.this.menuItem, SubstanceMenuUI.this.menuItem.getModel(), false, false, SubstanceMenuUI.this.menuItem), toIgnore);
                    SubstanceMenuUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceMenuUI.this.menuItem.updateUI();
                        }
                    });
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__jvnet__substance__SubstanceMenuUI__uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.menuItem.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return null;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (MenuUtilities.getPopupLayoutMetrics(this.menuItem) != null) {
            return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
        }
        return superDim;
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon, defaultTextIconGap);
    }
}

