/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceDefaultListCellRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        ListUI listUI = list.getUI();
        if (listUI instanceof SubstanceListUI) {
            SubstanceListUI ui = (SubstanceListUI)listUI;
            ComponentState state = ui.getCellState(index);
            ComponentState prevState = ui.getPrevCellState(index);
            SubstanceTheme theme = SubstanceThemeUtilities.getTheme(list, state);
            Color color = SubstanceCoreUtilities.getInterpolatedForegroundColor(list, Integer.valueOf(index), theme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(color);
        } else if (isSelected) {
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
        }
        if (!isSelected) {
            SubstanceCoreUtilities.applyStripedBackground(list, index, this);
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Insets ins = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(list));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
        this.setOpaque(true);
        return this;
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultListCellRenderer
    implements UIResource {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

