/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JViewport;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.preview.PreviewPainter;

public class DefaultPreviewPainter
extends PreviewPainter {
    public boolean hasPreview(Container parent, Component component, int componentIndex) {
        return component != null;
    }

    public void previewComponent(Container parent, Component component, int componentIndex, Graphics g, int x, int y, int w, int h) {
        if (component == null) {
            return;
        }
        int compWidth = component.getWidth();
        int compHeight = component.getHeight();
        if (compWidth > 0 && compHeight > 0) {
            BufferedImage tempCanvas = new BufferedImage(compWidth, compHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            component.paint(tempCanvasGraphics);
            double coef = Math.min((double)w / (double)compWidth, (double)h / (double)compHeight);
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)compWidth);
                int sdHeight = (int)(coef * (double)compHeight);
                int dx = x + (w - sdWidth) / 2;
                int dy = y + (h - sdHeight) / 2;
                g.drawImage(LafWidgetUtilities.createThumbnail(tempCanvas, sdWidth), dx, dy, null);
            } else {
                g.drawImage(tempCanvas, x, y, null);
            }
        }
    }

    public boolean hasPreviewWindow(Container parent, Component component, int componentIndex) {
        return true;
    }

    public Dimension getPreviewWindowDimension(Container parent, Component component, int componentIndex) {
        Dimension superResult = super.getPreviewWindowDimension(parent, component, componentIndex);
        if (parent instanceof JViewport) {
            Rectangle viewportRect = ((JViewport)parent).getViewRect();
            int width = Math.min(viewportRect.width / 3, superResult.width);
            int height = Math.min(viewportRect.height / 3, superResult.height);
            return new Dimension(width, height);
        }
        return superResult;
    }
}

