/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation.effects;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.EDTFadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;

public class GhostingListener {
    protected ChangeListener modelListener;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Map<FadeKind, Boolean> prevStateMap;

    public GhostingListener(Component comp, ButtonModel buttonModel) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.prevStateMap = new HashMap<FadeKind, Boolean>();
        this.prevStateMap.put(FadeKind.GHOSTING_ICON_ROLLOVER, buttonModel.isRollover());
        this.prevStateMap.put(FadeKind.GHOSTING_BUTTON_PRESS, buttonModel.isPressed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeKind fadeKind, boolean newState) {
        if (LafWidgetRepository.getRepository().getFadeIgnoreManager().toIgnoreAnimations(this.comp)) {
            return;
        }
        try {
            boolean prevState;
            if (this.prevStateMap.containsKey(fadeKind) && !(prevState = this.prevStateMap.get(fadeKind).booleanValue()) && newState) {
                FadeTracker.getInstance().trackFadeIn(fadeKind, this.comp, null, false, new EDTFadeTrackerAdapter(){

                    protected void repaintParent(int x, int y, int width, int height) {
                        if (GhostingListener.this.comp == null) {
                            return;
                        }
                        if (!GhostingListener.this.comp.isShowing()) {
                            return;
                        }
                        Component root = SwingUtilities.getRoot(GhostingListener.this.comp);
                        Rectangle compRect = GhostingListener.this.comp.getBounds();
                        compRect.setLocation(GhostingListener.this.comp.getLocationOnScreen());
                        compRect.x -= compRect.width / 2;
                        compRect.y -= compRect.height / 2;
                        compRect.width *= 2;
                        compRect.height *= 2;
                        root.repaint(compRect.x - root.getLocationOnScreen().x, compRect.y - root.getLocationOnScreen().y, compRect.width, compRect.height);
                    }

                    public void fadeEnded(FadeKind fadeKind) {
                        Rectangle bounds = GhostingListener.this.comp.getBounds();
                        double iWidth = bounds.width * 2;
                        double iHeight = bounds.height * 2;
                        int dx = (int)((iWidth - (double)bounds.width) / 2.0);
                        int dy = (int)((iHeight - (double)bounds.height) / 2.0);
                        this.repaintParent(bounds.x - dx, bounds.y - dy, (int)iWidth, (int)iHeight);
                    }

                    public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                        Rectangle bounds = GhostingListener.this.comp.getBounds();
                        double iFactor = 1.0 + (double)fadeCycle10 / 10.0;
                        double iWidth = (double)bounds.width * iFactor;
                        double iHeight = (double)bounds.height * iFactor;
                        int dx = (int)((iWidth - (double)bounds.width) / 2.0);
                        int dy = (int)((iHeight - (double)bounds.height) / 2.0);
                        this.repaintParent(bounds.x - dx, bounds.y - dy, (int)iWidth, (int)iHeight);
                    }
                }, LafWidgetUtilities.getAnimationKind(this.comp));
            }
        }
        finally {
            this.prevStateMap.put(fadeKind, newState);
        }
    }

    public void registerListeners() {
        this.modelListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.GHOSTING_ICON_ROLLOVER, GhostingListener.this.comp)) {
                    GhostingListener.this.trackModelChange(FadeKind.GHOSTING_ICON_ROLLOVER, GhostingListener.this.buttonModel.isRollover());
                }
                if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.GHOSTING_BUTTON_PRESS, GhostingListener.this.comp)) {
                    GhostingListener.this.trackModelChange(FadeKind.GHOSTING_BUTTON_PRESS, GhostingListener.this.buttonModel.isPressed());
                }
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
    }
}

