/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.DatabaseSetting;
import com.cadeveloper.api.Frontend;
import com.cadeveloper.models.Setting;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SettingsDialog
extends JFrame {
    private final DatabaseSetting databaseSettingsHelper = new DatabaseSetting();
    public JButton cmdAceptar;
    public JButton cmdCancelar;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel lblLogo;
    private JTextField txtDbName;
    private JTextField txtToken;
    private JTextField txtValue;

    public SettingsDialog() {
        this.initComponents();
        this.loadExistingSettings();
    }

    private void loadExistingSettings() {
        Setting existingSetting = this.databaseSettingsHelper.getFirstSetting();
        if (existingSetting != null) {
            this.txtDbName.setText(existingSetting.getDb_location());
            this.txtToken.setText(existingSetting.getToken());
            this.txtValue.setText("Fetched from API");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.cmdCancelar = new JButton();
        this.cmdAceptar = new JButton();
        this.lblLogo = new JLabel();
        this.jButton1 = new JButton();
        this.txtDbName = new JTextField();
        this.txtToken = new JTextField();
        this.jLabel1 = new JLabel();
        this.txtValue = new JTextField();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Control de Acceso"));
        GridBagLayout jPanel1Layout = new GridBagLayout();
        jPanel1Layout.columnWidths = new int[]{0, 4, 0, 4, 0, 4, 0};
        jPanel1Layout.rowHeights = new int[]{0, 4, 0, 4, 0, 4, 0, 4, 0};
        this.jPanel1.setLayout(jPanel1Layout);
        this.jLabel2.setText("Token:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.cmdCancelar.setIcon(new ImageIcon(this.getClass().getResource("/com/cadeveloper/icons/no.png")));
        this.cmdCancelar.setText("Cancelar");
        this.cmdCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.cmdCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.jPanel1.add((Component)this.cmdCancelar, gridBagConstraints);
        this.cmdAceptar.setIcon(new ImageIcon(this.getClass().getResource("/com/cadeveloper/icons/ok.png")));
        this.cmdAceptar.setText("Aceptar");
        this.cmdAceptar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.cmdAceptarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.cmdAceptar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.lblLogo, gridBagConstraints);
        this.jButton1.setText("Open DB:");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.txtDbName.setEnabled(false);
        this.txtDbName.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.txtDbName, gridBagConstraints);
        this.txtToken.setToolTipText("Paste the token");
        this.txtToken.setPreferredSize(new Dimension(64, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.txtToken, gridBagConstraints);
        this.jLabel1.setText("Valor Jugada (Auto):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.txtValue.setEnabled(false);
        this.txtValue.setText("Fetched from API");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.txtValue, gridBagConstraints);
        this.getContentPane().add(this.jPanel1);
        this.setSize(new Dimension(551, 206));
        this.setLocationRelativeTo(null);
    }

    private void cmdCancelarActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmdAceptarActionPerformed(ActionEvent evt) {
        this.saveData();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Database files", "db"));
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.txtDbName.setText(selectedFile.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
    }

    private void saveData() {
        boolean result;
        String dbName = this.txtDbName.getText();
        String token = this.txtToken.getText();
        String playValue = "0";
        if (dbName == null || dbName.trim().isEmpty() || token == null || token.trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please enter the required data (DB and Token)", "Settings Required", 2);
            return;
        }
        Setting existingSetting = this.databaseSettingsHelper.getFirstSetting();
        if (existingSetting != null) {
            this.databaseSettingsHelper.updateSetting(existingSetting.getId(), dbName, token, playValue);
            result = true;
        } else {
            result = this.databaseSettingsHelper.insertSetting(dbName, token, playValue);
        }
        if (result) {
            this.dispose();
            Frontend mainDialog = new Frontend(new JFrame(), true);
            mainDialog.setVisible(true);
        }
    }
}

