/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.Common;
import com.cadeveloper.api.Frontend;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class LocalDatabase {
    private String dbUrl;
    private final String dbUser;
    private final String dbPassword;
    private final Gson gson = new Gson();

    public LocalDatabase(String dbUser, String dbPassword) {
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.dbUrl = Common.setSQLitePath();
        this.createTableAccount();
        this.ensurePlayValueColumnExists();
        this.ensurePlayerCountColumnExists();
    }

    private void ensurePlayerCountColumnExists() {
        String alterQuery = "ALTER TABLE account ADD COLUMN player_count INTEGER DEFAULT 0;";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.execute(alterQuery);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensurePlayValueColumnExists() {
        String alterQuery = "ALTER TABLE account ADD COLUMN play_value TEXT DEFAULT '0';";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.execute(alterQuery);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createTableAccount() {
        String query = "CREATE TABLE IF NOT EXISTS account (id INTEGER PRIMARY KEY, pay_time TEXT, game_name TEXT, play_value TEXT, player_count INTEGER DEFAULT 0)";
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
             Statement stmt = conn.createStatement();){
            stmt.execute(query);
            Frontend.logMessage("Table 'account' created successfully!");
        }
        catch (SQLException e) {
            Frontend.logMessage("Error creating table 'account': " + e.getMessage());
        }
    }

    public String getRecordsFromAccountAsJson() {
        return this.getRecordsFromAccountAsJson(50);
    }

    public String getRecordsFromAccountAsJson(int limit) {
        ArrayList<JsonObject> records = new ArrayList<JsonObject>();
        String query = "SELECT * FROM account LIMIT " + limit;
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                JsonObject record = new JsonObject();
                record.addProperty("id", (Number)rs.getInt("id"));
                record.addProperty("pay_time", rs.getString("pay_time"));
                record.addProperty("game_name", rs.getString("game_name"));
                record.addProperty("player_count", (Number)rs.getInt("player_count"));
                record.addProperty("play_value", rs.getString("play_value"));
                records.add(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonArray jsonArray = this.gson.toJsonTree(records).getAsJsonArray();
        return this.gson.toJson((JsonElement)jsonArray);
    }

    public void deleteRecordsByIds(String jsonData) {
        block17: {
            try {
                JsonArray jsonArray = (JsonArray)this.gson.fromJson(jsonData, JsonArray.class);
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject obj = jsonArray.get(i).getAsJsonObject();
                    ids.add(obj.get("id").getAsInt());
                }
                if (ids.isEmpty()) break block17;
                String idList = String.join((CharSequence)",", (CharSequence[])ids.stream().map(String::valueOf).toArray(String[]::new));
                String deleteQuery = "DELETE FROM account WHERE id IN (" + idList + ");";
                try (Connection conn = DriverManager.getConnection(this.dbUrl);
                     Statement stmt = conn.createStatement();){
                    int deleted = stmt.executeUpdate(deleteQuery);
                    String message = "Deleted " + deleted + " records from local DB.";
                    Frontend.logMessage(message);
                    System.out.println("\ud83d\udfe2 LOCAL CLEANUP: " + message + " [" + new Date() + "]");
                }
                catch (SQLException e) {
                    Frontend.logMessage("Error deleting records: " + e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void insertRecordsFromJson(String jsonData) {
        String query = "INSERT OR IGNORE INTO account (id, pay_time, game_name, player_count, play_value) VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement(query);){
            JsonArray jsonArray = (JsonArray)this.gson.fromJson(jsonData, JsonArray.class);
            int insertedCount = 0;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject record = jsonArray.get(i).getAsJsonObject();
                int id = record.get("id").getAsInt();
                String payTime = record.get("pay_time").getAsString();
                String gameName = record.get("game_name").getAsString();
                int playerCount = record.has("player_count") ? record.get("player_count").getAsInt() : 1;
                String playValue = record.has("play_value") ? record.get("play_value").getAsString() : "0";
                pstmt.setInt(1, id);
                pstmt.setString(2, payTime);
                pstmt.setString(3, gameName);
                pstmt.setInt(4, playerCount);
                pstmt.setString(5, playValue);
                pstmt.addBatch();
                ++insertedCount;
            }
            pstmt.executeBatch();
            String message = "Records inserted/updated in local DB: " + insertedCount;
            Frontend.logMessage(message);
            System.out.println("\ud83d\udd34 LOCAL BACKUP: " + message + " [" + new Date() + "]");
        }
        catch (SQLException e) {
            Frontend.logMessage("Database error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void truncateLocalDatabase() {
        String query = "DELETE FROM account;";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(query);
            Frontend.logMessage("Local database truncated successfully!");
        }
        catch (SQLException e) {
            Frontend.logMessage("Database error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLocalRecordCount() {
        String query = "SELECT COUNT(*) as count FROM account";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) return 0;
            int n = rs.getInt("count");
            return n;
        }
        catch (SQLException e) {
            Frontend.logMessage("Error counting records: " + e.getMessage());
        }
        return 0;
    }
}

