/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.DataProcessor;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class GodPlayerDatabase {
    private final String dbUrl;
    private final String dbUser;
    private final String dbPassword;
    private final Gson gson = new Gson();
    private String playValue;

    public GodPlayerDatabase(String dbUrl, String dbUser, String dbPassword) {
        this.dbUrl = dbUrl;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.playValue = "0";
    }

    public void setPlayValue(String playValue) {
        this.playValue = playValue;
        System.out.println("\ud83d\udd27 GodPlayerDatabase.setPlayValue() called with: " + playValue);
    }

    public String getLastRecordsFromAccountAsJson() {
        ArrayList<JsonObject> records = new ArrayList<JsonObject>();
        this.ensureSentColumnExists();
        System.out.println("\ud83d\udcca Using play_value in JSON: " + this.playValue);
        String query = "SELECT * FROM account WHERE (sent IS NULL OR sent = 0) ORDER BY id ASC LIMIT 10;";
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                JsonObject record = new JsonObject();
                record.addProperty("id", (Number)rs.getInt("id"));
                record.addProperty("pay_time", rs.getString("pay_time"));
                byte[] rawData = rs.getBytes("data");
                String processedData = DataProcessor.processData(rawData);
                String[] parts = processedData.split("\\|");
                record.addProperty("game_name", parts.length > 0 ? parts[0] : "");
                record.addProperty("player_count", (Number)(parts.length > 1 ? Integer.parseInt(parts[1]) : 0));
                record.addProperty("play_value", this.playValue);
                records.add(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonArray jsonArray = this.gson.toJsonTree(records).getAsJsonArray();
        return this.gson.toJson((JsonElement)jsonArray);
    }

    private void ensureSentColumnExists() {
        String alterQuery = "ALTER TABLE account ADD COLUMN sent INTEGER DEFAULT 0;";
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
             Statement stmt = conn.createStatement();){
            stmt.execute(alterQuery);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void markRecordsAsSent(String jsonData) {
        block17: {
            try {
                JsonArray jsonArray = (JsonArray)this.gson.fromJson(jsonData, JsonArray.class);
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject obj = jsonArray.get(i).getAsJsonObject();
                    ids.add(obj.get("id").getAsInt());
                }
                if (ids.isEmpty()) break block17;
                String idList = String.join((CharSequence)",", (CharSequence[])ids.stream().map(String::valueOf).toArray(String[]::new));
                String updateQuery = "UPDATE account SET sent = 1 WHERE id IN (" + idList + ");";
                try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
                     Statement stmt = conn.createStatement();){
                    stmt.executeUpdate(updateQuery);
                    String message = "Marked " + ids.size() + " records as sent.";
                    System.out.println("\u2705 MARKED AS SENT: " + message + " [" + new Date() + "]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

