/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.ApiClient;
import com.cadeveloper.api.Common;
import com.cadeveloper.api.DatabaseSetting;
import com.cadeveloper.api.GodPlayerDatabase;
import com.cadeveloper.api.LocalDatabase;
import com.cadeveloper.api.SettingsDialog;
import com.cadeveloper.models.Setting;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class Frontend
extends JFrame {
    private final DatabaseSetting databaseSettingsHelper = new DatabaseSetting();
    private JButton cmdExit;
    private JButton cmdStart;
    private JButton cmdStop;
    private JLabel lblGamePrice;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JMenu mnuEditSetting;
    private JMenuItem mnuItemSettings;
    static JTextArea text_area_log;
    private ScheduledExecutorService scheduler;
    private String playValue;
    private volatile boolean isRunning = false;
    private boolean firstActivation = true;

    public Frontend(Frame parent, boolean modal) {
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frontend.this.handleWindowClose();
            }
        });
    }

    private void handleWindowClose() {
        boolean wasRunning = this.isRunning;
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.isRunning = false;
            this.scheduler.shutdownNow();
            Frontend.logMessage("\ud83d\uded1 Scheduler stopped for exit verification.");
            try {
                this.scheduler.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        JPasswordField passwordField = new JPasswordField();
        int option = JOptionPane.showConfirmDialog(this, passwordField, "Enter Password to Exit", 2, -1);
        Frontend.logMessage("Debug: handleWindowClose option value = " + option);
        if (option == 0) {
            String enteredPassword = new String(passwordField.getPassword());
            try {
                Setting setting = this.databaseSettingsHelper.getFirstSetting();
                ApiClient apiClient = Common.createApiClient(setting);
                if (apiClient == null) {
                    throw new Exception("Failed to create API client");
                }
                if (apiClient.verifyAccess("desktop_close_app", enteredPassword)) {
                    Frontend.logMessage("\u2705 Exit authorized - closing application window.");
                    this.dispose();
                    return;
                }
                JOptionPane.showMessageDialog(this, "Incorrect password!", "Access Denied", 0);
                if (wasRunning) {
                    this.cmdStart.setEnabled(false);
                    this.cmdStop.setEnabled(true);
                    this.runApi(true);
                }
                this.setVisible(true);
                this.toFront();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error contacting server: " + e.getMessage(), "Connection Error", 0);
                if (wasRunning) {
                    this.cmdStart.setEnabled(false);
                    this.cmdStop.setEnabled(true);
                    this.runApi(true);
                }
                this.setVisible(true);
                this.toFront();
            }
        } else if (option == 2 || option == -1) {
            if (wasRunning) {
                this.cmdStart.setEnabled(false);
                this.cmdStop.setEnabled(true);
                this.runApi(true);
            }
            this.setVisible(true);
            this.toFront();
            Frontend.logMessage("User cancelled exit; application continues running.");
        } else {
            if (wasRunning) {
                this.cmdStart.setEnabled(false);
                this.cmdStop.setEnabled(true);
                this.runApi(true);
            }
            this.setVisible(true);
            this.toFront();
            Frontend.logMessage("handleWindowClose: unexpected option=" + option);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.cmdExit = new JButton();
        this.cmdStart = new JButton();
        this.cmdStop = new JButton();
        this.jScrollPane1 = new JScrollPane();
        text_area_log = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.mnuEditSetting = new JMenu();
        this.mnuItemSettings = new JMenuItem();
        this.setTitle("Client Api");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                Frontend.this.formWindowActivated(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.cmdExit.setIcon(new ImageIcon(this.getClass().getResource("/com/cadeveloper/icons/exit.png")));
        this.cmdExit.setText("Exit");
        this.cmdExit.setFocusable(false);
        this.cmdExit.setHorizontalTextPosition(0);
        this.cmdExit.setVerticalTextPosition(3);
        this.cmdExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Frontend.this.cmdExitActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdExit);
        this.cmdStart.setIcon(new ImageIcon(this.getClass().getResource("/com/cadeveloper/icons/start.png")));
        this.cmdStart.setText("Start");
        this.cmdStart.setEnabled(false);
        this.cmdStart.setHorizontalTextPosition(0);
        this.cmdStart.setVerticalTextPosition(3);
        this.cmdStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Frontend.this.cmdStartActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdStart);
        this.cmdStop.setIcon(new ImageIcon(this.getClass().getResource("/com/cadeveloper/icons/pause.png")));
        this.cmdStop.setText("Stop");
        this.cmdStop.setFocusable(false);
        this.cmdStop.setHorizontalTextPosition(0);
        this.cmdStop.setVerticalTextPosition(3);
        this.cmdStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Frontend.this.cmdStopActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdStop);
        this.lblGamePrice = new JLabel();
        this.lblGamePrice.setText(" Price: - ");
        this.lblGamePrice.setFont(new Font("Tahoma", 1, 16));
        this.lblGamePrice.setForeground(new Color(204, 0, 0));
        this.jToolBar1.add(Box.createHorizontalGlue());
        this.jToolBar1.add(this.lblGamePrice);
        this.jToolBar1.add(Box.createHorizontalStrut(10));
        this.getContentPane().add((Component)this.jToolBar1, "First");
        text_area_log.setColumns(20);
        text_area_log.setRows(5);
        text_area_log.setEnabled(false);
        this.jScrollPane1.setViewportView(text_area_log);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.mnuEditSetting.setText("Edit");
        this.mnuItemSettings.setText("Settings");
        this.mnuItemSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Frontend.this.mnuItemEditSettingsActionPerformed(evt);
            }
        });
        this.mnuEditSetting.add(this.mnuItemSettings);
        this.jMenuBar1.add(this.mnuEditSetting);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(556, 328));
        this.setLocationRelativeTo(null);
    }

    private void cmdExitActionPerformed(ActionEvent evt) {
        this.handleWindowClose();
    }

    private void cmdStartActionPerformed(ActionEvent evt) {
        this.runApi(true);
    }

    private void formWindowActivated(WindowEvent evt) {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.runApi(true);
        }
    }

    private void cmdStopActionPerformed(ActionEvent evt) {
        JPasswordField passwordField = new JPasswordField();
        int option = JOptionPane.showConfirmDialog(this, passwordField, "Enter Password to Stop", 2, -1);
        if (option == 0) {
            String enteredPassword = new String(passwordField.getPassword());
            try {
                Setting setting = this.databaseSettingsHelper.getFirstSetting();
                ApiClient apiClient = Common.createApiClient(setting);
                if (apiClient == null) {
                    throw new Exception("Failed to create API client");
                }
                if (apiClient.verifyAccess("desktop_close_app", enteredPassword)) {
                    this.runApi(false);
                } else {
                    JOptionPane.showMessageDialog(this, "Incorrect password!", "Access Denied", 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error contacting server: " + e.getMessage(), "Connection Error", 0);
            }
        }
    }

    private void mnuItemEditSettingsActionPerformed(ActionEvent evt) {
        block12: {
            JPasswordField passwordField;
            int option;
            boolean wasRunning = this.isRunning;
            if (this.scheduler != null && !this.scheduler.isShutdown()) {
                this.isRunning = false;
                this.scheduler.shutdownNow();
                Frontend.logMessage("\ud83d\uded1 Scheduler stopped for settings edit.");
                try {
                    this.scheduler.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((option = JOptionPane.showConfirmDialog(this, passwordField = new JPasswordField(), "Enter Password", 2, -1)) == 0) {
                String enteredPassword = new String(passwordField.getPassword());
                try {
                    Setting setting = this.databaseSettingsHelper.getFirstSetting();
                    ApiClient apiClient = Common.createApiClient(setting);
                    if (apiClient == null) {
                        throw new Exception("Failed to create API client");
                    }
                    if (apiClient.verifyAccess("desktop_close_app", enteredPassword)) {
                        SettingsDialog settingsDialog = new SettingsDialog();
                        settingsDialog.setVisible(true);
                        this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(this, "Incorrect password!", "Access Denied", 0);
                        if (wasRunning) {
                            this.cmdStart.setEnabled(false);
                            this.cmdStop.setEnabled(true);
                            this.runApi(true);
                        }
                    }
                    break block12;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error contacting server: " + e.getMessage(), "Connection Error", 0);
                    if (wasRunning) {
                        this.cmdStart.setEnabled(false);
                        this.cmdStop.setEnabled(true);
                        this.runApi(true);
                    }
                    break block12;
                }
            }
            if (wasRunning) {
                this.cmdStart.setEnabled(false);
                this.cmdStop.setEnabled(true);
                this.runApi(true);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frontend dialog = new Frontend(new JFrame(), true);
                dialog.setVisible(true);
            }
        });
    }

    private void runApi(boolean status) {
        if (!status) {
            this.cmdStart.setEnabled(true);
            this.cmdStop.setEnabled(false);
            this.isRunning = false;
            if (this.scheduler != null && !this.scheduler.isShutdown()) {
                Frontend.logMessage("\ud83d\uded1 Stopping scheduler...");
                this.scheduler.shutdownNow();
                try {
                    if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                        Frontend.logMessage("\u26a0\ufe0f Scheduler did not terminate gracefully.");
                    } else {
                        Frontend.logMessage("\u2705 Scheduler stopped successfully.");
                    }
                }
                catch (InterruptedException e) {
                    this.scheduler.shutdownNow();
                    Thread.currentThread().interrupt();
                    Frontend.logMessage("\u26a0\ufe0f Scheduler interruption failed.");
                }
                this.scheduler = null;
            }
            return;
        }
        this.cmdStart.setEnabled(false);
        this.cmdStop.setEnabled(true);
        this.isRunning = true;
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            Frontend.logMessage("\u26a0\ufe0f Scheduler already running. Stop it first.");
            return;
        }
        Setting setting = this.databaseSettingsHelper.getFirstSetting();
        String app_token = setting.getToken();
        String dbPath = setting.getDb_location();
        this.playValue = setting.getPlay_value();
        Frontend.logMessage("\u2699\ufe0f Configuration loaded - Play Value: " + this.playValue);
        System.out.println("\u2699\ufe0f Play Value configured: " + this.playValue);
        GodPlayerDatabase godPlayerDatabase = new GodPlayerDatabase("jdbc:sqlite:" + dbPath, "", "");
        godPlayerDatabase.setPlayValue(this.playValue);
        LocalDatabase localDatabase = new LocalDatabase("", "");
        ApiClient apiClient = Common.createApiClient(app_token);
        if (apiClient == null) {
            Frontend.logMessage("\u274c Failed to create API client. Check configuration.");
            return;
        }
        new Thread(() -> {
            String price = apiClient.getGamePrice();
            if (price != null) {
                this.playValue = price = price.replace("\"", "").replace(" ", "").replace("}", "").replace(",", "");
                godPlayerDatabase.setPlayValue(price);
                String finalPrice = price;
                SwingUtilities.invokeLater(() -> {
                    try {
                        double amount = Double.parseDouble(finalPrice);
                        NumberFormat formatter = NumberFormat.getInstance();
                        String formattedPrice = formatter.format(amount);
                        this.lblGamePrice.setText(" Price: $" + formattedPrice + " ");
                        Frontend.logMessage("\ud83d\udcb0 Current Game Price: $" + formattedPrice);
                        Frontend.logMessage("\u2699\ufe0f Syncing sales with live price: $" + finalPrice);
                    }
                    catch (NumberFormatException e) {
                        this.lblGamePrice.setText(" Price: $" + finalPrice + " ");
                    }
                });
            }
        }).start();
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (!this.isRunning || Thread.currentThread().isInterrupted()) {
                    Frontend.logMessage("\ud83d\uded1 Scheduler task stopped.");
                    return;
                }
                System.out.println("\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501 CICLO DE SINCRONIZACI\u00d3N [" + new Date() + "] \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                int localCount = localDatabase.getLocalRecordCount();
                if (localCount > 0) {
                    Frontend.logMessage("\ud83d\udce6 Found " + localCount + " pending local records. Sending batch...");
                    System.out.println("\ud83d\udce6 MODO RECUPERACI\u00d3N: " + localCount + " registros pendientes en BD local");
                    String localRecordsJson = localDatabase.getRecordsFromAccountAsJson(50);
                    if (!localRecordsJson.equals("[]") && !localRecordsJson.isEmpty()) {
                        boolean localResponse = apiClient.sendPostRequest(localRecordsJson);
                        if (localResponse) {
                            localDatabase.deleteRecordsByIds(localRecordsJson);
                            Frontend.logMessage("\u2705 Local batch sent successfully! Remaining: " + (localCount - 50));
                        } else {
                            Frontend.logMessage("\u274c Failed to send local records. Will retry next cycle.");
                            System.out.println("\u26a0\ufe0f  API OFFLINE: Los datos permanecen en BD local para reintentar");
                            return;
                        }
                    }
                }
                if (localCount < 100) {
                    String lastRecordsJson = godPlayerDatabase.getLastRecordsFromAccountAsJson();
                    if (!lastRecordsJson.equals("[]") && !lastRecordsJson.isEmpty()) {
                        System.out.println("\ud83d\udce1 MODO NORMAL: Procesando nuevos registros de God Player DB");
                        boolean response = apiClient.sendPostRequest(lastRecordsJson);
                        if (response) {
                            godPlayerDatabase.markRecordsAsSent(lastRecordsJson);
                            Frontend.logMessage("\u2705 New records sent and marked successfully!");
                        } else {
                            localDatabase.insertRecordsFromJson(lastRecordsJson);
                            Frontend.logMessage("\ud83d\udcbe Failed to send new records, saved locally for retry.");
                            System.out.println("\u26a0\ufe0f  API OFFLINE: Datos guardados en BD local");
                        }
                    } else if (localCount == 0) {
                        Frontend.logMessage("\u2713 No new records to send. System up to date.");
                        System.out.println("\u2713 Sistema sincronizado - Sin registros pendientes");
                    }
                } else {
                    Frontend.logMessage("\u26a0\ufe0f  Too many pending local records (" + localCount + "). Skipping new records until backlog clears.");
                    System.out.println("\u26a0\ufe0f  BACKLOG ALTO: Priorizando env\u00edo de " + localCount + " registros pendientes");
                }
                System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\n");
            }
            catch (Exception e) {
                if (e instanceof InterruptedException || Thread.currentThread().isInterrupted()) {
                    Frontend.logMessage("Scheduler interrupted during execution.");
                    Thread.currentThread().interrupt();
                    return;
                }
                Frontend.logMessage("Error in scheduler: " + e.getMessage());
                e.printStackTrace();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public static void logMessage(String message) {
        text_area_log.append(message + "\n");
        text_area_log.setCaretPosition(text_area_log.getDocument().getLength());
    }
}

