/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.Common;
import com.cadeveloper.models.Setting;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseSetting {
    private String dbUrl = Common.setSQLitePath();

    public DatabaseSetting() {
        this.createTableSetting();
    }

    private void createTableSetting() {
        String query = "CREATE TABLE IF NOT EXISTS setting (id INTEGER PRIMARY KEY AUTOINCREMENT, db_location TEXT, token TEXT, play_value TEXT)";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.execute(query);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Boolean insertSetting(String dbLocation, String token, String playValue) {
        String query = "INSERT INTO setting (db_location, token, play_value) VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);){
            Boolean bl;
            block14: {
                PreparedStatement pstmt = conn.prepareStatement(query);
                try {
                    pstmt.setString(1, dbLocation);
                    pstmt.setString(2, token);
                    pstmt.setString(3, playValue);
                    pstmt.executeUpdate();
                    this.logMessage("Setting inserted successfully.");
                    bl = true;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logMessage("Error inserting setting: " + e.getMessage());
            return false;
        }
    }

    public void updateSetting(int id, String dbLocation, String token, String playValue) {
        String query = "UPDATE setting SET db_location = ?, token = ?, play_value = ? WHERE id = ?";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setString(1, dbLocation);
            pstmt.setString(2, token);
            pstmt.setString(3, playValue);
            pstmt.setInt(4, id);
            pstmt.executeUpdate();
            this.logMessage("Setting updated successfully.");
        }
        catch (SQLException e) {
            this.logMessage("Error updating setting: " + e.getMessage());
        }
    }

    public void deleteSetting(int id) {
        String query = "DELETE FROM setting WHERE id = ?";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setInt(1, id);
            pstmt.executeUpdate();
            this.logMessage("Setting deleted successfully.");
        }
        catch (SQLException e) {
            this.logMessage("Error deleting setting: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Setting getSetting(int id) {
        String query = "SELECT * FROM setting WHERE id = ?";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            Setting setting = new Setting(rs.getInt("id"), rs.getString("db_location"), rs.getString("token"), rs.getString("play_value"));
            return setting;
        }
        catch (SQLException e) {
            this.logMessage("Error retrieving setting: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Setting getFirstSetting() {
        String query = "SELECT * FROM setting ORDER BY id ASC LIMIT 1";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) return null;
            Setting setting = new Setting(rs.getInt("id"), rs.getString("db_location"), rs.getString("token"), rs.getString("play_value"));
            return setting;
        }
        catch (SQLException e) {
            this.logMessage("Error retrieving first setting: " + e.getMessage());
        }
        return null;
    }

    private void logMessage(String message) {
        System.out.print(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSettings() {
        String query = "SELECT COUNT(*) AS count FROM setting WHERE token IS NOT NULL AND token != ''";
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) return false;
            boolean bl = rs.getInt("count") > 0;
            return bl;
        }
        catch (SQLException e) {
            this.logMessage("Error checking settings: " + e.getMessage());
        }
        return false;
    }
}

