/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataProcessor {
    public static String processData(byte[] rawData) {
        if (rawData == null || rawData.length < 22) {
            System.out.println("\u26a0\ufe0f rawData too short: " + (rawData != null ? Integer.valueOf(rawData.length) : "null"));
            return "|0";
        }
        System.out.println("\ud83d\udd0d rawData bytes [0-25]:");
        for (int i = 0; i < Math.min(26, rawData.length); ++i) {
            System.out.printf("[%d]=0x%02X(%d) ", i, rawData[i] & 0xFF, rawData[i] & 0xFF);
            if ((i + 1) % 8 != 0) continue;
            System.out.println();
        }
        System.out.println();
        int playerCount = 0;
        int byte18 = rawData[18] & 0xFF;
        System.out.println("\ud83d\udd0d Byte[18] = " + byte18);
        if (byte18 >= 1 && byte18 <= 4) {
            playerCount = byte18;
            System.out.println("\u2705 player_count from byte[18]: " + playerCount);
        } else {
            System.out.println("\u26a0\ufe0f Byte[18] invalid, trying other positions...");
            for (int i = 16; i <= 20 && i < rawData.length; ++i) {
                int val = rawData[i] & 0xFF;
                if (val < 1 || val > 4) continue;
                playerCount = val;
                System.out.println("\u2705 Found player_count at byte[" + i + "]: " + playerCount);
                break;
            }
        }
        String textData = new String(rawData, StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile("[a-zA-Z0-9_]+");
        Matcher matcher = pattern.matcher(textData);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        String gameName = matches.isEmpty() ? "" : (String)matches.get(matches.size() - 1);
        System.out.println("\ud83d\udcca Result: " + gameName + " | players: " + playerCount);
        return gameName + "|" + playerCount;
    }
}

