/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.ApiClient;
import com.cadeveloper.models.Setting;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Common {
    private static final String CONFIG_DIR = "/god_player_api";
    private static final String CONFIG_FILE = "/god_player_api/config.properties";

    public static String setSQLitePath() {
        try {
            String userHome = System.getProperty("user.home");
            String configPath = userHome + CONFIG_DIR;
            String dbUrl = "jdbc:sqlite:" + configPath + "/api.db";
            return dbUrl;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String getConfigPath() {
        String userHome = System.getProperty("user.home");
        return userHome + CONFIG_FILE;
    }

    public static Properties loadProperties() {
        Properties properties;
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(Common.getConfigPath());
        try {
            props.load(input);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Error loading properties: " + e.getMessage());
                return null;
            }
        }
        input.close();
        return properties;
    }

    public static String getApiUrl() {
        Properties props = Common.loadProperties();
        if (props != null) {
            return props.getProperty("api.url");
        }
        return null;
    }

    public static ApiClient createApiClient(String token) {
        String apiUrl = Common.getApiUrl();
        if (apiUrl != null && token != null) {
            return new ApiClient(apiUrl, token);
        }
        return null;
    }

    public static ApiClient createApiClient(Setting setting) {
        if (setting != null) {
            return Common.createApiClient(setting.getToken());
        }
        return null;
    }
}

