/*
 * Decompiled with CFR 0.152.
 */
package com.cadeveloper.api;

import com.cadeveloper.api.Frontend;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;

public class ApiClient {
    private final String apiUrl;
    private final String bearerToken;

    public ApiClient(String apiUrl, String bearerToken) {
        this.apiUrl = apiUrl;
        this.bearerToken = bearerToken;
    }

    public boolean sendPostRequest(String data) {
        try {
            System.out.println("\n========== DATOS ENVIADOS AL API [" + new Date() + "] ==========");
            System.out.println("URL: " + this.apiUrl + "sales");
            System.out.println("Token (primeros 10 chars): " + (this.bearerToken != null && this.bearerToken.length() > 10 ? this.bearerToken.substring(0, 10) + "..." : this.bearerToken));
            System.out.println("Cantidad de registros: " + (data.startsWith("[") ? Integer.valueOf(data.split("\"id\":").length - 1) : "0"));
            System.out.println("Data: " + data);
            System.out.println("===========================================\n");
            URL url = new URL(this.apiUrl + "sales");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; utf-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", "Token " + this.bearerToken);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = data.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int code = conn.getResponseCode();
            if (code == 200) {
                Frontend.logMessage("Response status: OK");
                return true;
            }
            if (code == 401) {
                Frontend.logMessage("Unauthorized: Invalid or expired token");
                return false;
            }
            Frontend.logMessage("Response status: " + code);
            return false;
        }
        catch (Exception e) {
            Frontend.logMessage("Remote server is offline: " + e.getMessage());
            return false;
        }
    }

    public String getGamePrice() {
        try {
            URL url = new URL(this.apiUrl + "machines/current");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", "Token " + this.bearerToken);
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line.trim());
                }
                br.close();
                String resStr = response.toString();
                if (resStr.contains("\"game_price\":")) {
                    int priceIdx = resStr.indexOf("\"game_price\":") + 13;
                    int endIdx = resStr.indexOf(",", priceIdx);
                    if (endIdx == -1) {
                        endIdx = resStr.indexOf("}", priceIdx);
                    }
                    return resStr.substring(priceIdx, endIdx).trim();
                }
            }
            Frontend.logMessage("Failed to fetch game price. Response code: " + responseCode);
            return null;
        }
        catch (Exception e) {
            Frontend.logMessage("Error fetching game price: " + e.getMessage());
            return null;
        }
    }

    public boolean verifyAccess(String key, String attempt) {
        try {
            String line;
            String json = "{\"key\":\"" + ApiClient.escapeJson(key) + "\",\"attempt\":\"" + ApiClient.escapeJson(attempt) + "\"}";
            URL url = new URL(this.apiUrl + "settings/verify_access");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Token " + this.bearerToken);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = json.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            InputStream is = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line.trim());
            }
            br.close();
            return response.toString().contains("\"authorized\":true");
        }
        catch (Exception e) {
            Frontend.logMessage("Error verifying access: " + e.getMessage());
            return false;
        }
    }

    private static String escapeJson(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

